<%@ Control Language="c#" AutoEventWireup="false" Codebehind="WorksForResource.ascx.cs" Inherits="Mediachase.UI.Web.Projects.Modules.WorksForResource" TargetSchema="http://schemas.microsoft.com/intellisense/ie5"%>
<%@ register TagPrefix="dg" namespace="Mediachase.UI.Web.Modules.DGExtension" Assembly="Mediachase.UI.Web" %>
<script language='javascript'>
	function ChangeOT(obj)
	{
		document.forms[0].<%=cbCalEntries.ClientID%>.checked = obj.checked;
		document.forms[0].<%=cbIssues.ClientID%>.checked = obj.checked;
		document.forms[0].<%=cbDocs.ClientID%>.checked = obj.checked;
		document.forms[0].<%=cbTasks.ClientID%>.checked = obj.checked;
		document.forms[0].<%=cbToDo.ClientID%>.checked = obj.checked;
	}
	
	function DeleteItem(ItemType, ItemId)
	{
		document.forms[0].<%=hdnItemType.ClientID %>.value = ItemType;
		document.forms[0].<%=hdnItemId.ClientID %>.value = ItemId;
		var str = "";
		if(ItemType==5)
			str = "../Tasks/DeleteTaskModal.aspx";
		else if(ItemType==6)
			str = "../ToDo/DeleteToDoModal.aspx";
		else if(ItemType==4)
			str = "../Events/DeleteEventModal.aspx";
		else if(ItemType==7)
			str = "../Incidents/DeleteIncidentModal.aspx";
		else if(ItemType==16)
			str = "../Documents/DeleteDocumentModal.aspx";
		var DeleteType = FCKShowDialog(str, window, 420, 240);
		if (DeleteType == 'Task' || DeleteType == 'ToDo' || DeleteType == 'Event' || DeleteType == 'Incident' || DeleteType == 'Document')
			<%=Page.GetPostBackClientEvent(lbDeleteItem,"") %>
		if (DeleteType == 'All')
			<%=Page.GetPostBackClientEvent(lbDeleteItemAll,"") %>
		if (DeleteType == 'Catch')
		{
			if(confirm('<%=LocRM.GetString("tWarning")%>'))
				<%=Page.GetPostBackClientEvent(lbDeleteItem,"") %>
		}
	}
	
	function FCKShowDialog(pagePath, args, width, height)
	{
		if(browseris.ie5up)
		{
			return showModalDialog(pagePath, args, "dialogWidth:" + width + "px;dialogHeight:" + height + "px;help:no;scroll:auto;status:no");
		}
		else
		{
			return 'Catch';
		}
	}
</script>

<table runat="server" id="GroupTable" class="ibn-navline ibn-alternating" cellSpacing="0" cellPadding="7" width="100%" border="0">
	<tr height="40px">
		<td class="text" width="100px"><%=LocRM.GetString("tGroupBy")%>:</td>
		<td><asp:DropDownList ID="ddGrouping" Runat=server Width="190px"></asp:DropDownList></td>
		<td align=right height=100%>
			<table height=100% cellspacing="0" cellpadding="0" style="margin-top:-5">
				<tr>
					<td valign=top align=right>
						<asp:LinkButton ID="lbHideGroup" Runat=server CssClass=text></asp:LinkButton>
					</td>
				</tr>
				<tr>
					<td valign=bottom style="padding-top:10px">
						<nobr><asp:Button ID="btnApplyG" Runat=server Width="70px" CssClass="text"></asp:Button>
						<asp:Button ID="btnResetG" Runat=server Width="70px" CssClass="text"></asp:Button></nobr>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table id="tblGroupInfo" runat="server" class="ibn-navline text" cellSpacing="0" cellPadding="4" width="100%" border="0">
	<tr height="40px">
		<td>
			<asp:Label Runat="server" ID="lblGroupInfo"></asp:Label>
		</td>
		<td valign="bottom" align="right" height="100%">
			<table height="100%" cellspacing="0" cellpadding="0" style="margin-top:-5">
				<tr>
					<td valign=top align=right>
						<asp:LinkButton ID="lbShowGroup" Runat=server CssClass=text></asp:LinkButton>
					</td>
				</tr>
				<tr>
					<td valign=bottom style="padding-top:10px">
						<INPUT class="text" id="btnVResetG" type="submit" runat="server" style="width:120px" NAME="btnVResetG"/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table runat="server" id="FilterTable" class="ibn-navline ibn-alternating" cellSpacing="0" cellPadding="5" width="100%" border="0">
	<tr>
		<td width="250px" valign=top>
			<table class="text">
				<tr height="30px" id="trPerson" runat=server>
					<td class="text"><%=LocRM.GetString("tPerson")%>:</td>
					<td>
						<asp:DropDownList ID="ddPerson" Runat=server Width="190"></asp:DropDownList>
					</td>
				</tr>
				<tr height="30px" id="trProject" runat=server>
					<td class="text"><%=LocRM.GetString("tProject")%>:</td>
					<td>
						<asp:DropDownList id="ddPrjs" runat="server" Width="190px"></asp:DropDownList>
					</td>
				</tr>
				<tr height="30px">
					<td class="text"><%=LocRM.GetString("tManager")%>:</td>
					<td>
						<asp:DropDownList id="ddManager" runat="server" Width="190px"></asp:DropDownList>
					</td>
				</tr>
			</table>
		</td>
		<td width="180px" valign=top>
			<fieldset style="height:137px; margin-top:4">
				<legend class="text"><%=LocRM.GetString("State")%></legend>
				<table class="text" cellspacing="0" cellpadding="0" style="padding:4,0,0,4">
					<tr>
						<td><div style="margin-bottom:5"><%=LocRM.GetString("tShowCompleted")%>:</div>
							<asp:DropDownList id="ddCompleted" runat="server"	Width="160px"></asp:DropDownList>
						</td>
					</tr>
					<tr>
						<td><div style="margin-bottom:5"><%=LocRM.GetString("tActive")%>:</div>
							<asp:DropDownList id="ddShowActive" runat="server"	Width="160px"></asp:DropDownList>
						</td>
					</tr>
					<tr>
						<td><div style="margin-bottom:5"><%=LocRM.GetString("tShowUpcoming")%>:</div>
							<asp:DropDownList id="ddUpcoming" runat="server" Width="160px"></asp:DropDownList>
						</td>
					</tr>
				</table>
			</fieldset>
		</td>
		<td width="150px" valign=top>
			<fieldset style="height:140px">
				<legend class="text"><asp:CheckBox ID="cbChkAll" onclick='javascript:ChangeOT(this)' Runat=server></asp:CheckBox></legend>
				<table class="text" cellspacing="0">
					<tr>
						<td><asp:CheckBox ID="cbCalEntries" Runat=server></asp:CheckBox></td>
					</tr>
					<tr>
						<td><asp:CheckBox ID="cbIssues" Runat=server></asp:CheckBox></td>
					</tr>
					<tr>
						<td><asp:CheckBox ID="cbDocs" Runat=server></asp:CheckBox></td>
					</tr>
					<tr>
						<td><asp:CheckBox ID="cbTasks" Runat=server></asp:CheckBox></td>
					</tr>
					<tr>
						<td><asp:CheckBox ID="cbToDo" Runat=server></asp:CheckBox></td>
					</tr>
				</table>
			</fieldset>
		</td>
		<td height="100%">
			<table width=100% height=100% cellspacing="0" cellpadding="0" style="margin-top:-5">
				<tr>
					<td align=right valign=top>
						<asp:LinkButton ID="lbHideFilter" Runat=server CssClass=text></asp:LinkButton>
					</td>
				</tr>
				<tr>
					<td valign=bottom align=right>
						<nobr><asp:Button ID="btnApplyF" Runat=server CssClass="text" Width="75px"></asp:Button>
						<asp:Button ID="btnResetF" Runat=server CssClass="text" Width="75px"></asp:Button></nobr>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
<table id="tblFilterInfo" runat="server" class="ibn-navline text" cellSpacing="0" cellPadding="4" width="100%" border="0">
	<tr>
		<td valign="top" style="padding-bottom:5">
			<table cellspacing=3 cellpadding=0 border=0 runat="server" id="tblFilterInfoSet" class="text">
			</table>
		</td>
		<td valign="bottom" align="right" height="100%">
			<table height="100%" cellspacing="0" cellpadding="0" style="margin-top:-5">
				<tr>
					<td valign=top align=right>
						<asp:LinkButton ID="lbShowFilter" Runat=server CssClass=text></asp:LinkButton>
					</td>
				</tr>
				<tr>
					<td valign=bottom style="padding-top:10px">
						<INPUT class="text" id="btnVResetF" type="submit" runat="server" style="width:120px" NAME="btnVResetF"/>
					</td>
				</tr>
			</table>
		</td>
	</tr>
</table>
</td>
</tr>
<tr>
<td>
<dg:datagridextended id="dgObjects" runat="server" width="100%" autogeneratecolumns="False" 
	borderwidth="0px" CellSpacing="0" gridlines="Horizontal" cellpadding="0" allowsorting="True" 
	pagesize="10" allowpaging="True" EnableViewState=false LayoutFixed=false>
	<Columns>
		<asp:BoundColumn Visible="False" DataField="ItemId"></asp:BoundColumn>
		<asp:BoundColumn Visible="False" DataField="StateId"></asp:BoundColumn>
		<asp:BoundColumn Visible="False" DataField="ItemType"></asp:BoundColumn>
		<asp:TemplateColumn>
			<ItemStyle CssClass="ibn-vb4"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4" Width="20px"></HeaderStyle>
			<ItemTemplate>
				<%# GetPriorityIcon
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							(int)DataBinder.Eval(Container.DataItem, "PriorityId"),
							DataBinder.Eval(Container.DataItem, "PriorityName").ToString()
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Title" SortExpression="Title">
			<ItemStyle CssClass="ibn-vb4"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4"></HeaderStyle>
			<ItemTemplate>
				<%# GetTitle
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemId"),
							DataBinder.Eval(Container.DataItem, "Title").ToString(),
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							DataBinder.Eval(Container.DataItem, "GroupName"),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Type">
			<ItemStyle CssClass="ibn-vb4"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4"></HeaderStyle>
			<ItemTemplate>
				<%# GetType
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Project">
			<ItemStyle CssClass="ibn-vb4"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4"></HeaderStyle>
			<ItemTemplate>
				<%# GetProject
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							(int)DataBinder.Eval(Container.DataItem, "ProjectId"),
							DataBinder.Eval(Container.DataItem, "ProjectTitle").ToString(),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Manager" SortExpression="ManagerId">
			<ItemStyle CssClass="ibn-vb4"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4"></HeaderStyle>
			<ItemTemplate>
				<%# GetManager
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							(int)DataBinder.Eval(Container.DataItem, "ManagerId"),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Completed" SortExpression="PercentCompleted">
			<ItemStyle CssClass="ibn-vb4" width="110px"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4" width="110px"></HeaderStyle>
			<ItemTemplate>
				<%# GetPercentCompleted
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							(int)DataBinder.Eval(Container.DataItem, "PercentCompleted"),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Start" SortExpression="StartDate">
			<ItemStyle CssClass="ibn-vb4" width="80px"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4" width="80px"></HeaderStyle>
			<ItemTemplate>
				<%# GetDate
						(
							DataBinder.Eval(Container.DataItem, "StartDate"),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn HeaderText="Finish" SortExpression="FinishDate">
			<ItemStyle CssClass="ibn-vb4" width="80px"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4" width="80px"></HeaderStyle>
			<ItemTemplate>
				<%# GetDate
						(
							DataBinder.Eval(Container.DataItem, "FinishDate"),
							(int)DataBinder.Eval(Container.DataItem, "StateId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn>
			<ItemStyle CssClass="ibn-vb4" width="26px"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4" width="26px"></HeaderStyle>
			<ItemTemplate>
				<%# GetEditString
						(
							(int)DataBinder.Eval(Container.DataItem, "ItemType"),
							(int)DataBinder.Eval(Container.DataItem, "ItemId")
						)
				%>
			</ItemTemplate>
		</asp:TemplateColumn>
		<asp:TemplateColumn>
			<ItemStyle CssClass="ibn-vb4" width="26px"></ItemStyle>
			<HeaderStyle CssClass="ibn-vh4" width="26px"></HeaderStyle>
			<ItemTemplate>
				<asp:HyperLink id="ibDelete" runat="server" 
					ToolTip='<%#LocRM.GetString("Delete")%>'
					imageurl="../../layouts/images/DELETE.GIF" 
					NavigateUrl='<%# "javascript:DeleteItem(" + DataBinder.Eval(Container.DataItem, "ItemType").ToString() + "," + DataBinder.Eval(Container.DataItem, "ItemId").ToString() + ")" %>' >
				</asp:HyperLink>
			</ItemTemplate>
		</asp:TemplateColumn>
	</Columns>
</dg:datagridextended>
<asp:DataGrid ID="dgExport" Runat=server AutoGenerateColumns=False AllowPaging=False AllowSorting=False EnableViewState=False Visible=False ItemStyle-HorizontalAlign=Left HeaderStyle-Font-Bold=True >
	<Columns>
		<asp:BoundColumn DataField="Title"></asp:BoundColumn>
	</Columns>
</asp:DataGrid>
<asp:LinkButton id=lbExport runat="server" Visible="False"></asp:LinkButton>

<asp:LinkButton id="lbDeleteItem" runat="server" Visible="False"></asp:LinkButton>
<asp:LinkButton id="lbDeleteItemAll" runat="server" Visible="False"></asp:LinkButton>
<INPUT id="hdnItemId" type="hidden" runat="server" />
<INPUT id="hdnItemType" type="hidden" runat="server" />